
CURDIR=`dirname "$0"`
cd $CURDIR
CURDIR=`pwd`
LSWSHOME=`dirname $CURDIR`
LSWSHOME=`dirname $LSWSHOME`

display_usage()
{
    cat <<EOF
Usage: lsup.sh [-s] [-f] [-v VERSION] [-b BUILD_NUMBER]
  
  -f 
     Force reinstall. If -f is not given and same version already installed, this upgrade command is aborted. With -f option, latest build will be downloaded and installed even within same release version.

  -v VERSION
     If VERSION is given, this command will try to install specified VERSION. Otherwise, it will get the latest version from $LSWSHOME/autoupdate/release.

  -b BUILD_NUMBER
     Explicitily set the build number, it can be used to downgrade to an older build.

  -s
     Comunicate with server using HTTPS instead of HTTP.

  -w
     Do not run wswatch.sh

  --help     display this help and exit

EOF
    exit 1
}

FORCED=N
VERSION=x
BUILD=
DEBUG=0
HTTPS=s
NO_WSWATCH=0
while [ "x$1" != "x" ] 
do
    if [ "x$1" = "x-d" ] ; then
        DEBUG=1
    elif [ "x$1" = "x-f" ] ; then
        FORCED=Y
    elif [ "x$1" = "x-s" ] ; then
        HTTPS=s
    elif [ "x$1" = "x-w" ] ; then
        NO_WSWATCH=1
    elif [ "x$1" = "--help" ] ; then
        display_usage
    elif [ "x$1" = "x-v" ] ; then
        shift
        VERSION=$1
        if [ "x$VERSION" = "x" ] ; then
            display_usage
        fi
    elif [ "x$1" = "x-b" ] ; then
        shift
        BUILD="$1"
        if [ "x$BUILD" = "x" ] ; then
            display_usage
        fi
    else
        display_usage
    fi
    shift;
done


# detect download method
OS=`uname -s`
DLCMD=x
if [ "x$OS" = "xFreeBSD" ] ; then
    DL=`which fetch`
    if [ $? -eq 0 ] ; then
    DLCMD="$DL -o"
    fi
fi
if [ "$DLCMD" = "x" ] ; then
    DL=`which wget`
    if [ $? -eq 0 ] ; then
    DLCMD="$DL -nv -O"
    fi
fi
if [ "$DLCMD" = "x" ] ; then
    DL=`which curl`
    if [ $? -eq 0 ] ; then
    DLCMD="$DL -L -o"
    fi
fi
if [ "$DLCMD" = "x" ] ; then
    echo "[ERROR] Fail to detect proper download method"
    exit 1
fi

CURVERSION=`cat $LSWSHOME/VERSION`
CURBUILD=`cat $LSWSHOME/BUILD.$CURVERSION`
echo "Installed '$CURVERSION build $CURBUILD'"

# check stable release
LATEST_URL="http$HTTPS://update.litespeedtech.com/ws/latest.php"
$DLCMD "$LSWSHOME/autoupdate/latest" $LATEST_URL
LSWS_STABLE_LINE=`cat "$LSWSHOME/autoupdate/latest" | grep LSWS_STABLE`
LSWS_STABLE_VER=`expr "$LSWS_STABLE_LINE" : '.*LSWS_STABLE=\(.*\) BUILD .*'`
LSWS_STABLE_BUILD=`expr "$LSWS_STABLE_LINE" : '.*LSWS_STABLE=.* BUILD \(.*\)'`

if [ "x$CURVERSION" = "x$LSWS_STABLE_VER" ] && [ "x$CURBUILD" = "x$LSWS_STABLE_BUILD" ]; then
    touch "$LSWSHOME/autoupdate/follow_stable"
fi
if [ $VERSION = "x" ] && [ "$FORCED" = "N" ] ; then
    if [ "x$CURVERSION" = "x$LSWS_STABLE_VER" ] && [ "x$CURBUILD" = "x$LSWS_STABLE_BUILD" ]; then
        echo "Latest STABLE release has been installed. No update."
        exit 0
    fi

    if [ -f "$LSWSHOME/autoupdate/follow_stable" ]; then
        VERSION=$LSWS_STABLE_VER
        BUILD=$LSWS_STABLE_BUILD
        echo "Follow STABLE release '$LSWS_STABLE_VER build $LSWS_STABLE_BUILD'"
    else
        echo "Was not following STABLE releases, abort."
        echo "To start following STABLE release, run"
        echo "  lsup.sh -f -v $LSWS_STABLE_VER -b $LSWS_STABLE_BUILD"
        exit 2
    fi
fi

# check latest release
$LSWSHOME/bin/lshttpd -U

if [ ! -f "$LSWSHOME/autoupdate/release" ] ; then
    echo "[ERROR] Fail to locate file $LSWSHOME/autoupdate/release"
    exit 1
fi

if [ ! -f "$LSWSHOME/autoupdate/platform" ] ; then
    echo "[ERROR] Fail to locate file $LSWSHOME/autoupdate/platform"
    exit 1
fi

RELEASE=`cat $LSWSHOME/autoupdate/release`
PLATFORM=`cat $LSWSHOME/autoupdate/platform`
EDITION=`expr $RELEASE : '.*-\(.*\)'`
if [ $VERSION = "x" ] ; then
    VERSION=`expr $RELEASE : '\(.*\)-'`
else
    RELEASE="$VERSION-$EDITION"
fi

FILENAME="lsws-$RELEASE-$PLATFORM.tar.gz"
if [ -e "$LSWSHOME/autoupdate/$FILENAME" ] ; then
    /bin/rm -f "$LSWSHOME/autoupdate/$FILENAME"
fi

MAJOR_VERSION=`expr $VERSION : '\([0-9]*\)\..*'`
 
if [ $DEBUG =  '1' ]; then
    DOWNLOAD_URL="http$HTTPS://www.litespeedtech.com/packages/dbg/lsws-$RELEASE-$PLATFORM-dbg.tar.gz"
else
    DOWNLOAD_URL="http$HTTPS://www.litespeedtech.com/packages/$MAJOR_VERSION.0/$FILENAME"

    if [ "x$BUILD" =  'x' ]; then
        echo "Query latest build of $FILENAME"
        BUILD_URL=$DOWNLOAD_URL.lastbuild
        $DLCMD "$LSWSHOME/autoupdate/build" $BUILD_URL
        BUILD=`cat "$LSWSHOME/autoupdate/build"`
    fi
    if [ "x$BUILD" != 'x' ]; then
        if [ "$VERSION" = "$CURVERSION" ] && [ "x$CURBUILD" = "x$BUILD" ] && [ "$FORCED" = "N" ] ; then
            echo "Package $VERSION BUILD $CURBUILD already installed. If need to do force reinstall, please use option -f"
            exit 1
        fi
        echo "Download Build [$BUILD]."
    fi
    DOWNLOAD_URL="$DOWNLOAD_URL.$BUILD"
fi 

echo "$DLCMD $LSWSHOME/autoupdate/$FILENAME $DOWNLOAD_URL"

$DLCMD "$LSWSHOME/autoupdate/$FILENAME" $DOWNLOAD_URL

if [ $? != 0 ]; then
    echo "[ERROR] Failed to download $DOWNLOAD_URL"
    exit 2
fi

if [ "x$VERSION" = "x$LSWS_STABLE_VER" ] && [ "x$BUILD" = "x$LSWS_STABLE_BUILD" ]; then
    if [ ! -f "$LSWSHOME/autoupdate/follow_stable" ]; then
        echo "Start to follow STABLE releases."
        touch "$LSWSHOME/autoupdate/follow_stable"
    fi
elif [ -f "$LSWSHOME/autoupdate/follow_stable" ]; then
    echo "Diverted from STABLE releases."
    rm "$LSWSHOME/autoupdate/follow_stable"

fi

echo "$LSWSHOME/admin/misc/update.sh $VERSION $EDITION $PLATFORM"
$LSWSHOME/admin/misc/update.sh $VERSION $EDITION $PLATFORM

echo "Restarting LSWS"
if [ $NO_WSWATCH = 1 ]; then
    $LSWSHOME/bin/lswsctrl fullrestart
else
    $LSWSHOME/bin/lswsctrl fullrestart
fi
echo "Done"
