#!/bin/sh

# Pass in 1 as the first param to force remount cage

fixCageFS()
{
    if [ -f "/etc/cagefs/cagefs.mp" ] ; then
    # cagefs installed first, need update mount point
        FORCE_REMOUNT="${1}";
        REMOUNT=0
        LSWS_DIR="/usr/local/lsws"

        if ! grep -v 'deleted' < /proc/mounts | grep -q 'lsws'; then
            REMOUNT=1

            if ! grep -Eq "^${LSWS_DIR}$" "/etc/cagefs/cagefs.mp"; then
                # shellcheck disable=SC1003
                sed -i -e '$a\' "/etc/cagefs/cagefs.mp"
                echo "${LSWS_DIR}" >> "/etc/cagefs/cagefs.mp"

            fi
        fi

        if [ "${FORCE_REMOUNT}" -eq 1 ] || [ "${REMOUNT}" -eq 1 ]; then
            cagefsctl --remount-all
        fi

    fi
}

fixCageFS "${1:-0}"
