#!/bin/sh

RUBY_LSAPI_VER="5\\."
WSGI_LSAPI_VER=2.1

alt_ruby_install()
{
    # $1 = ruby version
    if [ "x$1" != "x" ]; then
        echo "Install ruby-lsapi rack gem for alt-ruby $1"
        yum install -y alt-ruby$1-rubygem-lsapi alt-ruby$1-rubygem-rack
        /opt/alt/ruby$1/bin/gem list ruby-lsapi | grep $RUBY_LSAPI_VER >/dev/null
        if [ $? -ne 0 ]; then
            echo "Alt-ruby $1 misses ruby-lsapi 5.x gem, install latest version."
            /opt/alt/ruby$1/bin/gem install ruby-lsapi
        fi
        echo ""
    fi
}

plesk_ruby_install()
{
    # $1 = ruby version
    # $2 = rack gem version
    if [ "x$1" != "x" ] && [ -d $1 ]; then
        echo "Install ruby-lsapi gem for Plesk ruby $1"
        $1/bin/gem install ruby-lsapi
        if [ "x$2" != "x" ]; then
            $1/bin/gem install rack -v=$2
        else
            $1/bin/gem install rack -v=2.2.4
        fi
        echo ""
    fi
}


for VER in '18' '19' '20' '21' '22' '23' '24' '25' '26' '27' '30'
do
    alt_ruby_install $VER
done

if [ -d /opt/plesk/ruby ]; then
    yum install -y gcc gmp-devel
    cd /opt/plesk/ruby
    for VER in '1.9.3' '2.0.0' '2.1.10'
    do
        plesk_ruby_install $VER 1.6.4
    done

    for VER in '2.2.10' '2.3.8' '2.4.10' '2.5.8' '2.6.6' '2.7.1'
    do
        plesk_ruby_install $VER
    done

fi

rm wsgi-lsapi-$WSGI_LSAPI_VER.tgz
rm -rf wsgi-lsapi-$WSGI_LSAPI_VER

wget http://www.litespeedtech.com/packages/lsapi/wsgi-lsapi-$WSGI_LSAPI_VER.tgz

tar xvfz wsgi-lsapi-$WSGI_LSAPI_VER.tgz
cd wsgi-lsapi-$WSGI_LSAPI_VER

if [ -d /opt/alt/python27 ]; then
    echo "Install wsgi-lsapi for python 2.7"
    yum install -y alt-python27-wsgi-lsapi
#     /opt/alt/python27/bin/python configure.py
#     make 1>/dev/null 2>&1
#     cp lswsgi /opt/alt/python27/bin/
#     make clean
fi

if [ -d /opt/alt/python33 ]; then
    echo "Install wsgi-lsapi for python 3.3"
    yum install -y alt-python33-wsgi-lsapi
fi

if [ -d /opt/alt/python34 ]; then
    echo "Install wsgi-lsapi for python 3.4"
    yum install -y alt-python34-wsgi-lsapi
fi

if [ -d /opt/alt/python35 ]; then
    echo "Install wsgi-lsapi for python 3.5"
    yum install -y alt-python35-wsgi-lsapi
fi

if [ -d /opt/alt/python36 ]; then
    echo "Install wsgi-lsapi for python 3.6"
    yum install -y alt-python36-wsgi-lsapi
fi


if [ -d /opt/alt/python37 ]; then
    echo "Install wsgi-lsapi for python 3.7"
    yum install -y alt-python37-wsgi-lsapi
fi

if [ -d /opt/alt/python38 ]; then
    echo "Install wsgi-lsapi for python 3.8"
    yum install -y alt-python38-wsgi-lsapi
    if [ ! -f /opt/alt/python38/bin/lswsgi ]; then
        /opt/alt/python38/bin/python3 configure.py
        sed -i -e "s#/opt/rh/devtoolset-7/root/usr/bin/##" Makefile
        make 1>/dev/null 2>&1
        cp lswsgi /opt/alt/python38/bin/
        make clean
    fi
fi

if [ -d /opt/alt/python39 ]; then
    echo "Install wsgi-lsapi for python 3.9"
    yum install -y alt-python39-wsgi-lsapi
    if [ ! -f /opt/alt/python39/bin/lswsgi ]; then
        /opt/alt/python39/bin/python3 configure.py
        yum install devtoolset-7-toolchain
#        sed -i -e "s#/opt/rh/devtoolset-7/root/usr/bin/##" Makefile
        make 1>/dev/null 2>&1
        cp lswsgi /opt/alt/python39/bin/
        make clean
    fi
fi

if [ -d /opt/alt/python310 ]; then
    echo "Install wsgi-lsapi for python 3.10"
    yum install -y alt-python310-wsgi-lsapi
    if [ ! -f /opt/alt/python310/bin/lswsgi ]; then
        /opt/alt/python310/bin/python3 configure.py
        yum install devtoolset-7-toolchain
#        sed -i -e "s#/opt/rh/devtoolset-7/root/usr/bin/##" Makefile
        make 1>/dev/null 2>&1
        cp lswsgi /opt/alt/python310/bin/
        make clean
    fi
fi

if [ -d /opt/cpanel/ea-ruby27/ ]; then
    echo "Install ruby-lsapi for ea-ruby27"
    scl enable ea-ruby27 'gem install ruby-lsapi'
    scl enable ea-ruby27 'gem install rack v=2.2.4'

    if [ ! -f /usr/local/lsws/fcgi-bin/ea-ruby27 ]; then
        cat >/usr/local/lsws/fcgi-bin/ea-ruby27 <<EOF
#!/bin/sh
. /opt/cpanel/ea-ruby27/enable
/opt/cpanel/ea-ruby27/root/usr/bin/ruby \$@

EOF
        chmod a+x /usr/local/lsws/fcgi-bin/ea-ruby27
    fi
    
fi

